﻿const capsuleLoots = {
    basic_capsule: [
        { item: 'cobblemon:ether', weight: 10, count: 1 },
        { item: 'cobblemon:max_ether', weight: 10, count: 1 },
        { item: 'cobblemon:elixir', weight: 10, count: 1 },
        { item: 'cobblemon:max_elixir', weight: 10, count: 1 }
    ],

    green_capsule: [
            { item: 'cobblemon:health_feather', weight: 10, count: 4 },
            { item: 'cobblemon:muscle_feather', weight: 10, count: 4 },
            { item: 'cobblemon:resist_feather', weight: 10, count: 4 },
            { item: 'cobblemon:genius_feather', weight: 10, count: 4 },
            { item: 'cobblemon:clever_feather', weight: 10, count: 4 },
            { item: 'cobblemon:swift_feather', weight: 10, count: 4 }
    ],

    yellow_capsule: [
        { item: 'cobblemon:revival_herb', weight: 10, count: 1 },
        { item: 'cobblemon:mirror_herb', weight: 10, count: 1 },
        { item: 'cobblemon:white_herb', weight: 10, count: 1 },
        { item: 'cobblemon:mental_herb', weight: 10, count: 1 },
        { item: 'cobblemon:power_herb', weight: 10, count: 1 }
    ],

    red_capsule: [
        { item: 'cobblemon:red_mint_seeds', weight: 10, count: 1 },
        { item: 'cobblemon:blue_mint_seeds', weight: 10, count: 1 },
        { item: 'cobblemon:cyan_mint_seeds', weight: 10, count: 1 },
        { item: 'cobblemon:pink_mint_seeds', weight: 10, count: 1 },
        { item: 'cobblemon:green_mint_seeds', weight: 10, count: 1 },
        { item: 'cobblemon:white_mint_seeds', weight: 10, count: 1 }
    ],

    poke_capsule: [
        { item: 'cobblemon:poke_ball', weight: 60, count: 5 }, 
        { item: 'cobblemon:great_ball', weight: 25, count: 3 },
        { item: 'cobblemon:ultra_ball', weight: 15, count: 2 },
        { item: 'cobblemon:safari_ball', weight: 4, count: 2 },
        { item: 'cobblemon:fast_ball', weight: 3, count: 2 },
        { item: 'cobblemon:level_ball', weight: 3, count: 2 },
        { item: 'cobblemon:lure_ball', weight: 3, count: 2 },
        { item: 'cobblemon:heavy_ball', weight: 2, count: 2 },
        { item: 'cobblemon:love_ball', weight: 2, count: 2 },
        { item: 'cobblemon:friend_ball', weight: 2, count: 2 },
        { item: 'cobblemon:moon_ball', weight: 2, count: 2 },
        { item: 'cobblemon:sport_ball', weight: 1, count: 2 },
        { item: 'cobblemon:net_ball', weight: 2, count: 2 },
        { item: 'cobblemon:dive_ball', weight: 2, count: 2 },
        { item: 'cobblemon:nest_ball', weight: 2, count: 2 },
        { item: 'cobblemon:repeat_ball', weight: 2, count: 2 },
        { item: 'cobblemon:timer_ball', weight: 2, count: 2 },
        { item: 'cobblemon:luxury_ball', weight: 1, count: 2 },
        { item: 'cobblemon:premier_ball', weight: 2, count: 2 },
        { item: 'cobblemon:dusk_ball', weight: 2, count: 2 },
        { item: 'cobblemon:heal_ball', weight: 2, count: 2 },
        { item: 'cobblemon:quick_ball', weight: 2, count: 2 },
        { item: 'cobblemon:cherish_ball', weight: 1, count: 1 },
        { item: 'cobblemon:park_ball', weight: 1, count: 1 },
        { item: 'cobblemon:dream_ball', weight: 1, count: 1 },
        { item: 'cobblemon:beast_ball', weight: 1, count: 1 }
    ],

    great_capsule: [
        { item: 'cobblemon:potion', weight: 50, count: 1 },
        { item: 'cobblemon:super_potion', weight: 40, count: 1 },
        { item: 'cobblemon:hyper_potion', weight: 30, count: 1 },
        { item: 'cobblemon:max_potion', weight: 20, count: 1 },
        { item: 'cobblemon:antidote', weight: 50, count: 1 },
        { item: 'cobblemon:awakening', weight: 50, count: 1 },
        { item: 'cobblemon:burn_heal', weight: 50, count: 1 },
        { item: 'cobblemon:ice_heal', weight: 50, count: 1 },
        { item: 'cobblemon:paralyze_heal', weight: 50, count: 1 },
        { item: 'cobblemon:full_restore', weight: 1, count: 1 },
        { item: 'cobblemon:remedy', weight: 2, count: 1 },
        { item: 'cobblemon:fine_remedy', weight: 2, count: 1 },
        { item: 'cobblemon:superb_remedy', weight: 2, count: 1 },
        { item: 'cobblemon:heal_powder', weight: 2, count: 1 },
        { item: 'cobblemon:full_heal', weight: 2, count: 1 },
        { item: 'cobblemon:revive', weight: 20, count: 1 },
        { item: 'cobblemon:max_revive', weight: 1, count: 1 }
    ],

    iron_capsule: [
        { item: 'cobblemon:hp_up', weight: 1, count: 1 },
        { item: 'cobblemon:protein', weight: 1, count: 1 },
        { item: 'cobblemon:iron', weight: 1, count: 1 },
        { item: 'cobblemon:calcium', weight: 1, count: 1 },
        { item: 'cobblemon:zinc', weight: 1, count: 1 },
        { item: 'cobblemon:carbos', weight: 1, count: 1 },
        { item: 'cobblemon:pp_up', weight: 1, count: 1 },
        { item: 'cobblemon:pp_max', weight: 1, count: 1 }
    ],

    copper_capsule: [
        { item: 'cobblemon:exp_candy_xs', weight: 40, count: 1 },
        { item: 'cobblemon:exp_candy_s', weight: 30, count: 1 },
        { item: 'cobblemon:exp_candy_m', weight: 20, count: 1 },
        { item: 'cobblemon:exp_candy_l', weight: 7, count: 1 },
        { item: 'cobblemon:exp_candy_xl', weight: 3, count: 1 },
        { item: 'cobblemon:rare_candy', weight: 1, count: 1 }
    ],

    gold_capsule: [
        { item: 'cobblemon:x_attack', weight: 10, count: 1 },
        { item: 'cobblemon:x_defence', weight: 10, count: 1 },
        { item: 'cobblemon:x_special_attack', weight: 10, count: 1 },
        { item: 'cobblemon:x_special_defence', weight: 10, count: 1 },
        { item: 'cobblemon:x_speed', weight: 10, count: 1 },
        { item: 'cobblemon:x_accuracy', weight: 10, count: 1 },
        { item: 'cobblemon:dire_hit', weight: 10, count: 1 },
        { item: 'cobblemon:guard_spec', weight: 10, count: 1 }
    ],

    emerald_capsule: [
        { item: 'cobblemizer:nature_changer_adamant', weight: 20, count: 1 },
        { item: 'cobblemizer:nature_changer_bashful', weight: 20, count: 1 },
        { item: 'cobblemizer:nature_changer_bold', weight: 20, count: 1 },
        { item: 'cobblemizer:nature_changer_brave', weight: 20, count: 1 },
        { item: 'cobblemizer:nature_changer_calm', weight: 20, count: 1 },
        { item: 'cobblemizer:nature_changer_careful', weight: 20, count: 1 },
        { item: 'cobblemizer:gender_swapper', weight: 5, count: 1 },
        { item: 'cobblemizer:shiny_swapper', weight: 0.1, count: 1 }
    ],

    ultra_capsule: [
        { item: 'cobblemon:normal_gem', weight: 1, count: 1 },
        { item: 'cobblemon:fire_gem', weight: 1, count: 1 },
        { item: 'cobblemon:water_gem', weight: 1, count: 1 },
        { item: 'cobblemon:grass_gem', weight: 1, count: 1 },
        { item: 'cobblemon:electric_gem', weight: 1, count: 1 },
        { item: 'cobblemon:rock_gem', weight: 1, count: 1 },
        { item: 'cobblemon:ground_gem', weight: 1, count: 1 },
        { item: 'cobblemon:bug_gem', weight: 1, count: 1 },
        { item: 'cobblemon:poison_gem', weight: 1, count: 1 },
        { item: 'cobblemon:ghost_gem', weight: 1, count: 1 },
        { item: 'cobblemon:psychic_gem', weight: 1, count: 1 },
        { item: 'cobblemon:dark_gem', weight: 1, count: 1 },
        { item: 'cobblemon:fairy_gem', weight: 1, count: 1 },
        { item: 'cobblemon:dragon_gem', weight: 1, count: 1 },
        { item: 'cobblemon:ice_gem', weight: 1, count: 1 },
        { item: 'cobblemon:fighting_gem', weight: 1, count: 1 },
        { item: 'cobblemon:flying_gem', weight: 1, count: 1 },
        { item: 'cobblemon:steel_gem', weight: 1, count: 1 }
    ],

    diamond_capsule: [
        { item: 'cobblemon:ability_shield', weight: 10, count: 1 },
        { item: 'cobblemon:absorb_bulb', weight: 10, count: 1 },
        { item: 'cobblemon:air_balloon', weight: 10, count: 1 },
        { item: 'cobblemon:assault_vest', weight: 10, count: 1 },
        { item: 'cobblemon:big_root', weight: 10, count: 1 },
        { item: 'cobblemon:binding_band', weight: 10, count: 1 },
        { item: 'cobblemon:black_belt', weight: 10, count: 1 },
        { item: 'cobblemon:black_glasses', weight: 10, count: 1 },
        { item: 'cobblemon:black_sludge', weight: 10, count: 1 },
        { item: 'cobblemon:blunder_policy', weight: 10, count: 1 },
        { item: 'cobblemon:cell_battery', weight: 10, count: 1 },
        { item: 'cobblemon:charcoal_stick', weight: 10, count: 1 },
        { item: 'cobblemon:choice_band', weight: 10, count: 1 },
        { item: 'cobblemon:choice_scarf', weight: 10, count: 1 },
        { item: 'cobblemon:choice_specs', weight: 10, count: 1 },
        { item: 'cobblemon:cleanse_tag', weight: 10, count: 1 },
        { item: 'cobblemon:covert_cloak', weight: 10, count: 1 },
        { item: 'cobblemon:destiny_knot', weight: 10, count: 1 },
        { item: 'cobblemon:deep_sea_scale', weight: 10, count: 1 },
        { item: 'cobblemon:deep_sea_tooth', weight: 10, count: 1 },
        { item: 'cobblemon:dragon_fang', weight: 10, count: 1 },
        { item: 'cobblemon:eject_button', weight: 10, count: 1 },
        { item: 'cobblemon:eject_pack', weight: 10, count: 1 },
        { item: 'cobblemon:everstone', weight: 10, count: 1 },
        { item: 'cobblemon:eviolite', weight: 10, count: 1 },
        { item: 'cobblemon:exp_share', weight: 10, count: 1 },
        { item: 'cobblemon:expert_belt', weight: 10, count: 1 },
        { item: 'cobblemon:fairy_feather', weight: 10, count: 1 },
        { item: 'cobblemon:flame_orb', weight: 10, count: 1 },
        { item: 'cobblemon:float_stone', weight: 10, count: 1 },
        { item: 'cobblemon:focus_band', weight: 10, count: 1 },
        { item: 'cobblemon:focus_sash', weight: 10, count: 1 },
        { item: 'cobblemon:hard_stone', weight: 10, count: 1 },
        { item: 'cobblemon:heavy_duty_boots', weight: 10, count: 1 },
        { item: 'cobblemon:iron_ball', weight: 10, count: 1 },
        { item: 'cobblemon:kings_rock', weight: 10, count: 1 },
        { item: 'cobblemon:leftovers', weight: 10, count: 1 },
        { item: 'cobblemon:life_orb', weight: 10, count: 1 },
        { item: 'cobblemon:light_ball', weight: 10, count: 1 },
        { item: 'cobblemon:light_clay', weight: 10, count: 1 },
        { item: 'cobblemon:loaded_dice', weight: 10, count: 1 },
        { item: 'cobblemon:lucky_egg', weight: 10, count: 1 },
        { item: 'cobblemon:magnet', weight: 10, count: 1 },
        { item: 'cobblemon:metal_coat', weight: 10, count: 1 },
        { item: 'cobblemon:miracle_seed', weight: 10, count: 1 },
        { item: 'cobblemon:muscle_band', weight: 10, count: 1 },
        { item: 'cobblemon:mystic_water', weight: 10, count: 1 },
        { item: 'cobblemon:never_melt_ice', weight: 10, count: 1 },
        { item: 'cobblemon:poison_barb', weight: 10, count: 1 },
        { item: 'cobblemon:power_anklet', weight: 10, count: 1 },
        { item: 'cobblemon:power_band', weight: 10, count: 1 },
        { item: 'cobblemon:power_belt', weight: 10, count: 1 },
        { item: 'cobblemon:power_bracer', weight: 10, count: 1 },
        { item: 'cobblemon:power_lens', weight: 10, count: 1 },
        { item: 'cobblemon:power_weight', weight: 10, count: 1 },
        { item: 'cobblemon:quick_claw', weight: 10, count: 1 },
        { item: 'cobblemon:razor_claw', weight: 10, count: 1 },
        { item: 'cobblemon:razor_fang', weight: 10, count: 1 },
        { item: 'cobblemon:red_card', weight: 10, count: 1 },
        { item: 'cobblemon:ring_target', weight: 10, count: 1 },
        { item: 'cobblemon:rocky_helmet', weight: 10, count: 1 },
        { item: 'cobblemon:safety_goggles', weight: 10, count: 1 },
        { item: 'cobblemon:sharp_beak', weight: 10, count: 1 },
        { item: 'cobblemon:shell_bell', weight: 10, count: 1 },
        { item: 'cobblemon:silk_scarf', weight: 10, count: 1 },
        { item: 'cobblemon:silver_powder', weight: 10, count: 1 },
        { item: 'cobblemon:smoke_ball', weight: 10, count: 1 },
        { item: 'cobblemon:soft_sand', weight: 10, count: 1 },
        { item: 'cobblemon:spell_tag', weight: 10, count: 1 },
        { item: 'cobblemon:sticky_barb', weight: 10, count: 1 },
        { item: 'cobblemon:toxic_orb', weight: 10, count: 1 },
        { item: 'cobblemon:twisted_spoon', weight: 10, count: 1 },
        { item: 'cobblemon:weakness_policy', weight: 10, count: 1 },
        { item: 'cobblemon:wise_glasses', weight: 10, count: 1 },
        { item: 'cobblemon:bright_powder', weight: 10, count: 1 },
        { item: 'cobblemon:metal_powder', weight: 10, count: 1 },
        { item: 'cobblemon:quick_powder', weight: 10, count: 1 },
        { item: 'cobblemon:mental_herb', weight: 10, count: 1 },
        { item: 'cobblemon:mirror_herb', weight: 10, count: 1 },
        { item: 'cobblemon:power_herb', weight: 10, count: 1 },
        { item: 'cobblemon:white_herb', weight: 10, count: 1 },
        { item: 'cobblemon:damp_rock', weight: 10, count: 1 },
        { item: 'cobblemon:heat_rock', weight: 10, count: 1 },
        { item: 'cobblemon:smooth_rock', weight: 10, count: 1 },
        { item: 'cobblemon:icy_rock', weight: 10, count: 1 },
        { item: 'cobblemon:life_orb', weight: 10, count: 1 },
        { item: 'cobblemon:toxic_orb', weight: 10, count: 1 },
        { item: 'cobblemon:flame_orb', weight: 10, count: 1 },
        { item: 'cobblemon:white_herb', weight: 10, count: 1 },
        { item: 'cobblemon:smoke_ball', weight: 10, count: 1 },
        { item: 'cobblemon:lucky_egg', weight: 10, count: 1 },
        { item: 'cobblemon:kings_rock', weight: 10, count: 1 },
        { item: 'cobblemon:deep_sea_scale', weight: 10, count: 1 },
        { item: 'cobblemon:deep_sea_tooth', weight: 10, count: 1 },
        { item: 'cobblemon:metal_coat', weight: 10, count: 1 },
        { item: 'cobblemon:medicinal_leek', weight: 10, count: 1 },
        { item: 'minecraft:bone', weight: 10, count: 1 },
        { item: 'minecraft:snowball', weight: 10, count: 1 }
    ],
    netherite_capsule: [
        { item: 'cobblemizer:friendship_add_common', weight: 20, count: 1 },
        { item: 'cobblemizer:friendship_add_uncommon', weight: 15, count: 1 },
        { item: 'cobblemizer:friendship_add_rare', weight: 10, count: 1 },
        { item: 'cobblemizer:friendship_add_epic', weight: 5, count: 1 },
        { item: 'cobblemizer:friendship_add_legendary', weight: 0.1, count: 1 },
        { item: 'cobblemizer:friendship_add_max', weight: 0.01, count: 1 }
    ],
    cherish_capsule: [
        { item: 'cobblemizer:iv_add_sp_atk_common', weight: 20, count: 1 },
        { item: 'cobblemizer:iv_add_sp_def_common', weight: 20, count: 1 },
        { item: 'cobblemizer:iv_add_speed_common', weight: 20, count: 1 },
        { item: 'cobblemizer:iv_add_atk_common', weight: 20, count: 1 },
        { item: 'cobblemizer:iv_add_def_common', weight: 20, count: 1 },
        { item: 'cobblemizer:iv_add_hp_common', weight: 20, count: 1 },
        { item: 'cobblemizer:iv_add_sp_atk_uncommon', weight: 15, count: 1 },
        { item: 'cobblemizer:iv_add_sp_def_uncommon', weight: 15, count: 1 },
        { item: 'cobblemizer:iv_add_speed_uncommon', weight: 15, count: 1 },
        { item: 'cobblemizer:iv_add_atk_uncommon', weight: 15, count: 1 },
        { item: 'cobblemizer:iv_add_def_uncommon', weight: 15, count: 1 },
        { item: 'cobblemizer:iv_add_hp_uncommon', weight: 15, count: 1 },
        { item: 'cobblemizer:iv_add_sp_atk_rare', weight: 10, count: 1 },
        { item: 'cobblemizer:iv_add_sp_def_rare', weight: 10, count: 1 },
        { item: 'cobblemizer:iv_add_speed_rare', weight: 10, count: 1 },
        { item: 'cobblemizer:iv_add_atk_rare', weight: 10, count: 1 },
        { item: 'cobblemizer:iv_add_def_rare', weight: 10, count: 1 },
        { item: 'cobblemizer:iv_add_hp_rare', weight: 10, count: 1 },
        { item: 'cobblemizer:iv_add_sp_atk_epic', weight: 5, count: 1 },
        { item: 'cobblemizer:iv_add_sp_def_epic', weight: 5, count: 1 },
        { item: 'cobblemizer:iv_add_speed_epic', weight: 5, count: 1 },
        { item: 'cobblemizer:iv_add_atk_epic', weight: 5, count: 1 },
        { item: 'cobblemizer:iv_add_def_epic', weight: 5, count: 1 },
        { item: 'cobblemizer:iv_add_hp_epic', weight: 5, count: 1 },
        { item: 'cobblemizer:iv_add_sp_atk_legendary', weight: 0.1, count: 1 },
        { item: 'cobblemizer:iv_add_sp_def_legendary', weight: 0.1, count: 1 },
        { item: 'cobblemizer:iv_add_speed_legendary', weight: 0.1, count: 1 },
        { item: 'cobblemizer:iv_add_atk_legendary', weight: 0.1, count: 1 },
        { item: 'cobblemizer:iv_add_def_legendary', weight: 0.1, count: 1 },
        { item: 'cobblemizer:iv_add_hp_legendary', weight: 0.1, count: 1 },
        { item: 'cobblemizer:iv_add_sp_atk_max', weight: 0.01, count: 1 },
        { item: 'cobblemizer:iv_add_sp_def_max', weight: 0.01, count: 1 },
        { item: 'cobblemizer:iv_add_speed_max', weight: 0.01, count: 1 },
        { item: 'cobblemizer:iv_add_atk_max', weight: 0.01, count: 1 },
        { item: 'cobblemizer:iv_add_def_max', weight: 0.01, count: 1 },
        { item: 'cobblemizer:iv_add_hp_max', weight: 0.01, count: 1 }
    ],
    copper_alt_capsule: [
        { item: 'cobblemon:dawn_stone', weight: 10, count: 1 },
        { item: 'cobblemon:dusk_stone', weight: 10, count: 1 },
        { item: 'cobblemon:fire_stone', weight: 10, count: 1 },
        { item: 'cobblemon:ice_stone', weight: 10, count: 1 },
        { item: 'cobblemon:leaf_stone', weight: 10, count: 1 },
        { item: 'cobblemon:moon_stone', weight: 10, count: 1 },
        { item: 'cobblemon:shiny_stone', weight: 10, count: 1 },
        { item: 'cobblemon:sun_stone', weight: 10, count: 1 },
        { item: 'cobblemon:thunder_stone', weight: 10, count: 1 },
        { item: 'cobblemon:water_stone', weight: 10, count: 1 }
    ],

    gold_alt_capsule: [
        { item: 'cobblemizer:lvl_add_common', weight: 20, count: 1 },
        { item: 'cobblemizer:lvl_add_uncommon', weight: 15, count: 1 },
        { item: 'cobblemizer:lvl_add_rare', weight: 10, count: 1 },
        { item: 'cobblemizer:lvl_add_epic', weight: 5, count: 1 },
        { item: 'cobblemizer:lvl_add_legendary', weight: 0.1, count: 1 },
        { item: 'cobblemizer:lvl_add_max', weight: 0.01, count: 1 }
    ],
    emerald_alt_capsule: [
        { item: 'kubejs:normal_plate', weight: 1, count: 1 },
        { item: 'kubejs:fire_plate', weight: 1, count: 1 },
        { item: 'kubejs:water_plate', weight: 1, count: 1 },
        { item: 'kubejs:grass_plate', weight: 1, count: 1 },
        { item: 'kubejs:electric_plate', weight: 1, count: 1 },
        { item: 'kubejs:rock_plate', weight: 1, count: 1 },
        { item: 'kubejs:ground_plate', weight: 1, count: 1 },
        { item: 'kubejs:bug_plate', weight: 1, count: 1 },
        { item: 'kubejs:poison_plate', weight: 1, count: 1 },
        { item: 'kubejs:ghost_plate', weight: 1, count: 1 },
        { item: 'kubejs:psychic_plate', weight: 1, count: 1 },
        { item: 'kubejs:dark_plate', weight: 1, count: 1 },
        { item: 'kubejs:fairy_plate', weight: 1, count: 1 },
        { item: 'kubejs:dragon_plate', weight: 1, count: 1 },
        { item: 'kubejs:ice_plate', weight: 1, count: 1 },
        { item: 'kubejs:fighting_plate', weight: 1, count: 1 },
        { item: 'kubejs:flying_plate', weight: 1, count: 1 },
        { item: 'kubejs:steel_plate', weight: 1, count: 1 }
    ],

    netherite_alt_capsule: [
        { item: 'cobblemon:helix_fossil', weight: 10, count: 1 },
        { item: 'cobblemon:dome_fossil', weight: 10, count: 1 },
        { item: 'cobblemon:old_amber_fossil', weight: 10, count: 1 },
        { item: 'cobblemon:root_fossil', weight: 10, count: 1 },
        { item: 'cobblemon:claw_fossil', weight: 10, count: 1 },
        { item: 'cobblemon:skull_fossil', weight: 10, count: 1 },
        { item: 'cobblemon:armor_fossil', weight: 10, count: 1 },
        { item: 'cobblemon:cover_fossil', weight: 10, count: 1 },
        { item: 'cobblemon:plume_fossil', weight: 10, count: 1 },
        { item: 'cobblemon:jaw_fossil', weight: 10, count: 1 },
        { item: 'cobblemon:sail_fossil', weight: 10, count: 1 },
        { item: 'cobblemon:fossilized_bird', weight: 10, count: 1 },
        { item: 'cobblemon:fossilized_fish', weight: 10, count: 1 },
        { item: 'cobblemon:fossilized_drake', weight: 10, count: 1 },
        { item: 'cobblemon:fossilized_dino', weight: 10, count: 1 },
        { item: 'kubejs:shinyfossil', weight: 0.1, count: 1 },
        { item: 'kubejs:maxivfossil', weight: 1, count: 1 },
        { item: 'kubejs:hafossil', weight: 1, count: 1 }
    ],

    diamond_alt_capsule: [
        { item: 'kubejs:gen1incense', weight: 10, count: 1 },
        { item: 'kubejs:gen2incense', weight: 10, count: 1 },
        { item: 'kubejs:gen3incense', weight: 10, count: 1 },
        { item: 'kubejs:gen4incense', weight: 10, count: 1 },
        { item: 'kubejs:gen5incense', weight: 10, count: 1 },
        { item: 'kubejs:gen6incense', weight: 10, count: 1 },
        { item: 'kubejs:gen7incense', weight: 10, count: 1 },
        { item: 'kubejs:gen8incense', weight: 10, count: 1 },
        { item: 'kubejs:gen9incense', weight: 10, count: 1 },
        { item: 'kubejs:shinyincense', weight: 1, count: 1 },
        { item: 'kubejs:stongshinyincense', weight: 0.1, count: 1 },
        { item: 'kubejs:ubershinyincense', weight: 0.001, count: 1 }
    ],

    iron_alt_capsule: [
        { item: 'cobblemon:link_cable', weight: 10, count: 1 },
        { item: 'cobblemon:dragon_scale', weight: 10, count: 1 },
        { item: 'cobblemon:kings_rock', weight: 10, count: 1 },
        { item: 'cobblemon:metal_coat', weight: 10, count: 1 },
        { item: 'cobblemon:upgrade', weight: 10, count: 1 },
        { item: 'cobblemon:dubious_disc', weight: 10, count: 1 },
        { item: 'cobblemon:deep_sea_scale', weight: 10, count: 1 },
        { item: 'cobblemon:deep_sea_tooth', weight: 10, count: 1 },
        { item: 'cobblemon:electirizer', weight: 10, count: 1 },
        { item: 'cobblemon:magmarizer', weight: 10, count: 1 },
        { item: 'cobblemon:oval_stone', weight: 10, count: 1 },
        { item: 'cobblemon:protector', weight: 10, count: 1 },
        { item: 'cobblemon:reaper_cloth', weight: 10, count: 1 },
        { item: 'cobblemon:prism_scale', weight: 10, count: 1 },
        { item: 'cobblemon:sachet', weight: 10, count: 1 },
        { item: 'cobblemon:whipped_dream', weight: 10, count: 1 },
        { item: 'cobblemon:strawberry_sweet', weight: 5, count: 1 },
        { item: 'cobblemon:love_sweet', weight: 5, count: 1 },
        { item: 'cobblemon:berry_sweet', weight: 5, count: 1 },
        { item: 'cobblemon:clover_sweet', weight: 5, count: 1 },
        { item: 'cobblemon:flower_sweet', weight: 5, count: 1 },
        { item: 'cobblemon:star_sweet', weight: 5, count: 1 },
        { item: 'cobblemon:ribbon_sweet', weight: 5, count: 1 },
        { item: 'cobblemon:sweet_apple', weight: 8, count: 1 },
        { item: 'cobblemon:tart_apple', weight: 8, count: 1 },
        { item: 'cobblemon:galarica_cuff', weight: 7, count: 1 },
        { item: 'cobblemon:galarica_wreath', weight: 7, count: 1 },
        { item: 'cobblemon:black_augurite', weight: 6, count: 1 },
        { item: 'cobblemon:peat_block', weight: 6, count: 1 },
        { item: 'cobblemon:razor_claw', weight: 9, count: 1 },
        { item: 'cobblemon:razor_fang', weight: 9, count: 1 },
        { item: 'cobblemon:auspicious_armor', weight: 4, count: 1 },
        { item: 'cobblemon:malicious_armor', weight: 4, count: 1 }
    ],

    master_capsule: [
        { item: 'myths_and_legends:adamant_orb', weight: 5 },
        { item: 'myths_and_legends:aurora_ticket', weight: 5 },
        { item: 'myths_and_legends:azure_flute', weight: 5 },
        { item: 'myths_and_legends:blue_orb', weight: 5 },
        { item: 'myths_and_legends:bonus_disk', weight: 5 },
        { item: 'myths_and_legends:clear_bell', weight: 5 },
        { item: 'myths_and_legends:cocoon_of_destruction', weight: 5 },
        { item: 'myths_and_legends:dark_stone', weight: 5 },
        { item: 'myths_and_legends:dna_splicer', weight: 5 },
        { item: 'myths_and_legends:dr_fujis_diary', weight: 5 },
        { item: 'myths_and_legends:eon_flute', weight: 5 },
        { item: 'myths_and_legends:eon_ticket', weight: 5 },
        { item: 'myths_and_legends:gs_ball', weight: 5 },
        { item: 'myths_and_legends:griseous_orb', weight: 5 },
        { item: 'myths_and_legends:jade_orb', weight: 5 },
        { item: 'myths_and_legends:liberty_pass', weight: 5 },
        { item: 'myths_and_legends:light_stone', weight: 5 },
        { item: 'myths_and_legends:lustrous_orb', weight: 5 },
        { item: 'myths_and_legends:magma_stone', weight: 5 },
        { item: 'myths_and_legends:member_card', weight: 5 },
        { item: 'myths_and_legends:moon_flute', weight: 5 },
        { item: 'myths_and_legends:mystery_box', weight: 5 },
        { item: 'myths_and_legends:old_sea_map', weight: 5 },
        { item: 'myths_and_legends:oaks_letter', weight: 5 },
        { item: 'myths_and_legends:rainbow_wing', weight: 5 },
        { item: 'myths_and_legends:red_chain', weight: 5 },
        { item: 'myths_and_legends:red_orb', weight: 5 },
        { item: 'myths_and_legends:reveal_glass', weight: 5 },
        { item: 'myths_and_legends:rusted_shield', weight: 5 },
        { item: 'myths_and_legends:rusted_sword', weight: 5 },
        { item: 'myths_and_legends:sapling_of_life', weight: 5 },
        { item: 'myths_and_legends:scarlet_book', weight: 5 },
        { item: 'myths_and_legends:silver_wing', weight: 5 },
        { item: 'myths_and_legends:sun_flute', weight: 5 },
        { item: 'myths_and_legends:teal_mask', weight: 5 },
        { item: 'myths_and_legends:tidal_bell', weight: 5 },
        { item: 'myths_and_legends:violet_book', weight: 5 },
        { item: 'myths_and_legends:zygarde_cell', weight: 5 },
        { item: 'myths_and_legends:zygarde_core', weight: 5 },
        { item: 'myths_and_legends:zygarde_cube', weight: 5 }
    ],
};
function getRandomLoot(lootList) {
    let totalWeight = lootList.reduce((total, loot) => total + loot.weight, 0);
    let randomWeight = Math.floor(Math.random() * totalWeight);
    let currentWeight = 0;

    for (let loot of lootList) {
        currentWeight += loot.weight;
        if (randomWeight < currentWeight) {
            return loot;
        }
    }
}

ItemEvents.rightClicked( event => {
    const player = event.player;
    const itemInHand = player.getMainHandItem();

    if (itemInHand.id.contains('capsule')) {
        const capsuleType = itemInHand.id.split(':')[1]; 

        if (capsuleLoots[capsuleType]) {
            const loot = getRandomLoot(capsuleLoots[capsuleType]);
            itemInHand.count--;
            player.give(Item.of(loot.item, loot.count));
            player.tell('Vous avez ouvert une capsule ' + capsuleType + ' et obtenu : ' + loot.item);
        }
    }
});
